/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.spark.fabric.smap;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.objectweb.asm.tree.ClassNode;
import org.spongepowered.asm.service.IClassBytecodeProvider;
import org.spongepowered.asm.service.MixinService;

public final class SourceDebugCache
extends Enum<SourceDebugCache> {
    private static final Map<String, SmapValue> CACHE;
    private static final /* synthetic */ SourceDebugCache[] $VALUES;

    public static SourceDebugCache[] values() {
        return (SourceDebugCache[])$VALUES.clone();
    }

    public static SourceDebugCache valueOf(String name) {
        return Enum.valueOf(SourceDebugCache.class, name);
    }

    public static void put(String className, ClassNode node) {
        if (className == null || node == null) {
            return;
        }
        className = className.replace('/', '.');
        CACHE.put(className, SmapValue.of(node.sourceDebug));
    }

    public static String getSourceDebugInfo(String className) {
        SmapValue cached = CACHE.get(className);
        if (cached != null) {
            return cached.value();
        }
        try {
            IClassBytecodeProvider provider = MixinService.getService().getBytecodeProvider();
            ClassNode classNode = provider.getClassNode(className.replace('.', '/'));
            if (classNode != null) {
                SourceDebugCache.put(className, classNode);
                return classNode.sourceDebug;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        CACHE.put(className, SmapValue.NULL);
        return null;
    }

    private static /* synthetic */ SourceDebugCache[] $values() {
        return new SourceDebugCache[0];
    }

    static {
        $VALUES = SourceDebugCache.$values();
        CACHE = new ConcurrentHashMap<String, SmapValue>();
    }

    private record SmapValue(String value) {
        static final SmapValue NULL = new SmapValue(null);

        static SmapValue of(String value) {
            if (value == null) {
                return NULL;
            }
            return new SmapValue(value);
        }
    }
}

